import openai
import os
import json
import jsonlines
from argparse import ArgumentParser
from tqdm import tqdm
import backoff
import random
import sys


@backoff.on_exception(backoff.expo, (openai._exceptions.RateLimitError, openai._exceptions.APITimeoutError, openai._exceptions.APIError))
def chat_complete(model, messages):
    response = model.chat.completions.create(
        model="gpt-3.5-turbo-0125",
        messages=messages,
        temperature=0.1,
        max_tokens=2000,
    )
    return response.choices[0].message.content


if __name__ == "__main__":
    parser = ArgumentParser()
    parser.add_argument("--api_key", type=str, default="")
    parser.add_argument("--model_name", type=str, default="gemini-1.5-flash-latest")
    parser.add_argument("--data", type=str, default="../output/ecare_fact.jsonl")
    parser.add_argument("--instruction", type=str, default="./prompt_gsm8k_w_options.txt")
    parser.add_argument("--output", type=str, default="./ecare_augmented.jsonl")
    parser.add_argument("--round", type=int, default=1)
    args = parser.parse_args()

    model = openai.OpenAI(api_key=args.api_key)
    data = [d for d in jsonlines.open(f"./round{args.round}/{args.data}.jsonl", "r")]

    args.output = f"./round{args.round}/{args.data}_retrieved.jsonl"
    if os.path.exists(args.output):
        index = len([d for d in jsonlines.open(args.output, "r")])
        fo = jsonlines.open(args.output, "a")
    else:
        index = 0
        fo = jsonlines.open(args.output, "w")
    
    data = data[index:]
    bar = tqdm(data)
    prompt = open(args.instruction, "r").read()

    for example in bar:
        Q = example['Q'] if "Q" in example else example['question']
        chat = [
            {"role": "system", "content": prompt},
            {"role": "user", "content": f"Question: {Q}"},
        ]
        response = chat_complete(model, chat)
        chat.append({"role": "assistant", "content": response})

        example['messages'] = chat
        fo.write(example)
    fo.close()








